# -*- mode: python ; coding: utf-8 -*-

# THIS FILE IS USED FOR WINDOWS PYINSTALLER BUILDS ONLY (mods marked "# [ML]")

from kivy_deps import sdl2, glew    # [ML]


block_cipher = None


a = Analysis(
    ['main.py'],
    pathex=[],
    binaries=[],
    datas=[],
    hiddenimports=['PIL', 'win32timezone', 'ctypes'],
    hookspath=[],
    hooksconfig={},
    runtime_hooks=[],
    excludes=[],
    win_no_prefer_redirects=False,
    win_private_assemblies=False,
    cipher=block_cipher,
    noarchive=False,
)

pyz = PYZ(a.pure, a.zipped_data, cipher=block_cipher)

splash = Splash(
    'usbsync.png',          # [ML] not rounded: pyinstaller|tkinter botches border
    binaries=a.binaries,
    datas=a.datas,
    text_pos=None,
    text_size=12,
    minify_script=True,
    always_on_top=True,
)

#--------------------------------------------------------------------
# [ML] [1.2.0] Tighten up source-code visibility with excludes=[...]
# in added Tree(), so raw .py source-code files are not exposed in 
# PyInstaller _MEI* Temp unzip folders (an undocumented side-effect
# of a Tree() spec-file insert required+prescribed by Kivy!).
#
# This applies only to the GUI's code (Mergeall's code used for
# file ops is fully open source); and only to Windows (Linux and
# macOS exe/dir don't add a Tree('.') and so don't include .pys, 
# and Andoid's Buildozer has different source-code policies). 
#
# PyInstaller used to have a '--key' encrypted-bytecode option,
# but dropped it in 6.0 because it was too weak: keys were shipped
# in PI exes, and Github has tools to extract+decrypt+decompyle.  
# Encryption or not, PyInstaller packages code, but hides it from 
# casual eyes only; this might encourage open source and free. 
# (Ref: https://github.com/pyinstaller/pyinstaller/pull/6999).
#
# Also closed up a code leak for manually input paths on Android.
# In the end, this all may be a moot point: it's probaby easier 
# to make a workalike app than steal+mod+rebuild this one's vast 
# Python code, and Play payola and audience naiveté remain hurdles.
#--------------------------------------------------------------------

exe = EXE(
    pyz,
    Tree('.', excludes=['*.py', '*.pyw']),    # [ML] else no window object, and app aborts
    a.scripts,                                # [ML] BUT use excludes to hide source [1.2]
    a.binaries,
    a.zipfiles,
    a.datas,
    splash,
    splash.binaries,
    [],
    *[Tree(p) for p in (sdl2.dep_bins + glew.dep_bins)],    # [ML] for window provider
    name='PC-Phone USB Sync',
    debug=False,
    bootloader_ignore_signals=False,
    strip=False,
    upx=True,
    upx_exclude=[],
    runtime_tmpdir=None,
    console=False,                          # [ML] True: no logging error (kivy bug)
    disable_windowed_traceback=False,
    argv_emulation=False,
    target_arch=None,
    codesign_identity=None,
    entitlements_file=None,
    version='_winver.txt',
    icon='usbsync-pc/icon-round.png',    # [ML] rounded version, custom .ico fails (why?)
)
